


/**
 ******************************************************************************
 *
 * @file        MG32_USBD_EasyPODMini.h
 * @brief       
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2024/10/04
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _MG32_USBD_EASYPODMINI_H
#define _MG32_USBD_EASYPODMINI_H

/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_USB_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Typedef -------------------------------------------------------------------*/
/* Define --------------------------------------------------------------------*/
#define    HIBYTE( V1 )     ((uint8_t)((V1) >> 8))          /*!<Get high byte (8 ~ 15 bit) of 16 bit data.*/
#define    LOBYTE( V1 )     ((uint8_t)((V1) & 0xFF))        /*!<Get low byte (8 ~ 15 bit) of 16 bit data.*/

#define USBD_SUCCESS        0
#define USBD_FAILURE        1

#define API_USBD_CONSUMER_TX_EP USB_EP3                     /*!<Consumer TX endpoint define ( The define endpoint can't change).*/
#define API_USBD_CONSUMER_RX_EP USB_EP3                     /*!<Consumer RX endpoint define ( The define endpoint can't change).*/

#define DEVICE_DESCRIPTOR        0x01                       /*!<Device Descriptor.*/

#define FKB_TOTALFUNCTION        0x14

#define KB_FUNHID_ID_FKB         1                          /*!< HID Multimedia ID.*/
#define KB_FUNHID_ID_SYSTEM      2                          /*!< HID System power control ID.*/

//------------------------------------------------
// USBStatus Control Relationship Define.
#define    USB_STATUS_DEFAULT                           0x00000000            /*!<USB software status default value.*/
#define    USB_STATUS_EMULATION_MASK                    0x80000000            /*!<Emulation status mask of USB software status .*/
    #define    USB_STATUS_EMULATION_OK                            0x80000000  /*!<Emulation status of USB software status is success.*/
    #define    USB_STATUS_EMULATION_NO                            0x00000000  /*!<Emulation status of USB software status is not yet successful.*/
#define    USB_STATUS_RWEN_MASK                         0x40000000            /*!<Remote wakeup function mask of USB software status.*/
    #define    USB_STATUS_RWEN_ENABLE                             0x40000000  /*!<Remote wakeup enable.*/
    #define    USB_STATUS_RWEN_DISABLE                            0x00000000  /*!<Remote wakeup disable.*/
#define    USB_STATUS_BUS_MASK                          0x00FF0000            /*!<USB Bus status mask of USB software status.*/
    #define    USB_STATUS_BUS_ACT                                 0x00000000  /*!<USB Bus Active.*/
    #define    USB_STATUS_BUS_RESET                               0x00010000  /*!<USB Bus Reset.*/
    #define    USB_STATUS_BUS_SUSPEND                             0x00020000  /*!<USB Bus Suspend.*/
    #define    USB_STATUS_BUS_RESUME                              0x00040000  /*!<USB Bus Resume.*/
    #define    USB_STATUS_BUS_EXTIEVENT_WAKEUP                    0x00080000  /*!<External signal wakeup device.*/
    #define    USB_STATUS_BUS_BUSEVENT_WAKEUP                     0x00100000  /*!<Bus event wakeup device.*/
    
/* Macro ---------------------------------------------------------------------*/
/* Variables -----------------------------------------------------------------*/
//Descriptor
extern const uint8_t MFS_LENn;
extern const uint8_t PDS_LENn;
extern const uint8_t SNS_LENn;

extern const uint8_t USB_DEVICE_DESCRIPTOR[];  
extern  const uint8_t Manufacturer_Descriptor[];
extern const uint8_t Product_Descriptor[];
extern const uint8_t SerialNumber_Descriptor[];

extern const uint8_t USBD_EasyPODIN_bInterval;
extern const uint8_t USBD_EasyPODOUT_bInterval;

//consumer
extern volatile uint8_t InFlag; 
extern uint8_t InBuffer[64];
extern uint8_t InLen;


/* Function prototypes -------------------------------------------------------*/                                  
//USB module
void Init(void);                                                             /*!< USB module initial.*/
void API_USBD_ResetIRQCallback(void);                                        /*!< USB module detect Bus reset interrupt callback function.*/

/**
 *******************************************************************************
 * @brief	    Write a constant value to TX SRAM of the endpoint.
 * @details 
 * @param[in]   EPX      : ( USB_EP0 ~ USB_EP7) Select control which endpoint register.
 * @param[in]   ConstData: Constant value.
 * @param[in]   cTXShift : Write address is that shift address from the TX start SRAM address.
 * @param[in]   cTXCnt   : Write total data size.
 * @return      
 * @exception   No
 * @note        TX SRAM address of the endpoint have to set.              
 *******************************************************************************
 */ 
void API_USBD_WriteEndpointConstData( USB_EP_Struct* EPX, uint8_t ConstData , uint32_t cTXShift , uint8_t cTXCnt );

//USB status
uint32_t API_USBD_ReadUSBStatus(void);
void API_USBD_ClearUSBStatus(uint32_t USBD_Status);
void API_USBD_SetUSBStatus(uint32_t USBD_Status);


//Keyboard                                                                  
void API_USBD_KBStandard_TxCpltIRQCallback(void);                            /*!< Keyboard standard report transmit complete interrupt handler callback function.*/
void API_USBD_KBConsumerSystem_TxCpltIRQCallback(void);                      /*!< Keyboard compliant cosumer / system control transmit complete interrupt handler callback function.*/
void API_USBD_KB_SetLEDStatusCallback(uint8_t KB_LEDStatus );                /*!< Host control LED Keyboard LED.*/ 
void API_USBD_KB_SetIdleRateCallback(uint8_t KB_IdleRate);
void API_USBD_KB_SetProtocolCallback(uint8_t KB_Protocol);
uint8_t API_USBD_KB_GetLEDStatusCallback(void);
uint8_t API_USBD_KB_GetIdleRateCallback(void);
uint8_t API_USBD_KB_GetProtocolCallback(void);
//Consumer
/**
 *******************************************************************************
 * @brief       Consumer endpoint channel transmit.
 * @details  
 * @param[in]   Buffer: Transmit data source pointer.
 * @param[in]   Len: Transmit data size.
 * @return      No
 * @note
 *******************************************************************************
 */
void USB_Send_Data_To_PC( uint32_t Len, uint8_t* Buffer);


/**
 *******************************************************************************
 * @brief	    Receive consumer RX endpoint channel to receive next
 *              package data into cosumer RX endpoint hardware SRAM.                        
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void USB_Read_Data_Complete(void);




#endif







